C
C------------------------------------------------------
C
C   Problem:    TRAN_A_B
C
C   Date:       29.07.2004
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Va0 = 1.6
      Vb0 = 2.8
      Vcell = 0.0094
      Sm = 4.7
      C0 = 7
C
C-------------------------------------------------------
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      Pa, Pb, Vmax, K, Ca, Cb, Mcell, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Ca_t
      Ccell=Mcell/Vcell
      Ca_t = -Pa*(Ca - Ccell)*Sm/Va0 + Vmax*Mcell/((Mcell + K)*Va0)
C
*     FUNCTION Cb_t
      Cb_t = Pb*(Ccell - Cb)*Sm/Vb0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION Mcell_e
      Mcell_e = Va0*C0 - Mcell - Ca*Va0 - Cb*Vb0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     diff-erential equations (t=0):
C
*     FUNCTION Ca_0
      Ca_0 = C0
C
*     FUNCTION Cb_0
      Cb_0 = 0
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION Mcell_0
      Mcell_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ca_fit
      Ca_fit = Ca
C
*     FUNCTION Cb_fit
      Cb_fit = Cb
C
*     FUNCTION Mcell_fit
      Mcell_fit = Mcell
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
