C
C------------------------------------------------------
C
C   Problem:    TRANSUS1
C
C   Date:       15.06.2005
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Va0 = 1.6
      Vb0 = 2.8
      Vc  = 0.0094
      Sm  = 4.7
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      P, vmax, K, C0ab, C0ba, Caab
      Cbab, Mcab, Caba, Cbba, Mcba, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Caab_t
      Ccab = Mcab/Vc
      Va = Va0 - 0.003719*t + 3.68e-6*t**2 + 6.87e-9*t**3
      Caab_t = -P*(Caab - Ccab)*Sm/Va + vmax*Mcab/((Mcab + K)*Va)
C
*     FUNCTION Cbab_t
      Ccab = Mcab/Vc
      Vb = Vb0 - 0.003719*t + 3.68e-6*t**2 + 6.87e-9*t**3
      Cbab_t = P*(Ccab - Cbab)*Sm/Vb
C
*     FUNCTION Mcab_t
      Ccab = Mcab/Vc
      Mcab_t = P*(Caab - Ccab)*Sm - vmax*Mcab/(Mcab + K)-P*(Ccab - Cbab)*Sm
C
*     FUNCTION Caba_t
      Ccba = Mcba/Vc
      Caba_t = P*(Ccba - Caba)*Sm/Va + vmax*Mcba/((Mcba + K)*Va)
C
*     FUNCTION Cbba_t
      Ccba = Mcba/Vc
      Cbba_t = -P*(Cbba - Ccba)*Sm/Vb
C
*     FUNCTION Mcba_t
      Ccba = Mcba/Vc
      Mcba_t = P*(Cbba - Ccba)*Sm - P*(Ccba - Caba)*Sm - vmax*Mcba/(Mcba + K)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Caab_0
      Caab_0 = C0ab
C
*     FUNCTION Cbab_0
      Cbab_0 = 0
C
*     FUNCTION Mcab_0
      Mcab_0 = 0
C
*     FUNCTION Caba_0
      Caba_0 = 0
C
*     FUNCTION Cbba_0
      Cbba_0 = C0ba
C
*     FUNCTION Mcba_0
      Mcba_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Caab_fit
      Caab_fit = Caab
C
*     FUNCTION Cbab_fit
      Cbab_fit = Cbab
C
*     FUNCTION Caba_fit
      Caba_fit = Caba
C
*     FUNCTION Cbba_fit
      Cbba_fit = Cbba
C
*     FUNCTION Mcab_fit
      Mcab_fit = Mcab
C
*     FUNCTION Mcba_fit
      Mcba_fit = Mcba
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
