C
C------------------------------------------------------
C
C     Problem:    TRANSIST
C
C     Date:       18.01.1994
C
C------------------------------------------------------
C
*     REAL CONSTANT
      PI = 3.1415926535897
      R0 = 1.0
      R1 = 9.0
      R2 = 9.0
      R3 = 9.0
      R4 = 9.0
      R5 = 9.0
      UB = 6.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. variables identifying solution of corresponding
C        algebraic equations (z)
C     4. concentration variable, if exists (c)
C     5. time variable (t)
C
*     VARIABLE
      CI1, CI2, CI3, Y1, Y2, Y3, Z1, Z2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      UE  = 0.4*DSIN(200*PI*T)
      F   = 1.0D-3*(DEXP((Z1 - Y1 - Y2)/0.026) - 1)
      Y1P = (UE - Z1)*CI1/R0
C
*     FUNCTION Y2P
      Y2P = (F - Y2/R3)*CI2
C
*     FUNCTION Y3P
      Y3P = ((UB - Z2)/R4 - 0.99*F)*CI3
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     algebraic equations:
C
*     FUNCTION EQ1
      EQ1 = UB/R2 - (Z1 - Y1)*(1/R1 + 1/R2) 
     /         + (UE - Z1)/R0 - 0.01*F
C
*     FUNCTION EQ2
      EQ2 = (UB - Z2)/R4 - (Z2 - Y3)/R5 - 0.99*F
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = -UB*R1/(R1 + R2)
C
*     FUNCTION Y20
      Y20 = UB*R1/(R1 + R2)
C
*     FUNCTION Y30
      Y30 = UB
C
C------------------------------------------------------
C
C   - Initial values for solving systems of algebraic
C     equations (t=0):
C
*     FUNCTION Z10
      Z10 = 0
C
*     FUNCTION Z20
      Z20 = UB
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION FIT
      FIT = Z2 - Y3
C
*     FUNCTION Y1_PLOT
      Y1_PLOT = Y1
C
*     FUNCTION Y2_PLOT
      Y2_PLOT = Y2
C
*     FUNCTION Y3_PLOT
      Y3_PLOT = Y3
C
*     FUNCTION Z1_PLOT
      Z1_PLOT = Z1
C
*     FUNCTION Z2_PLOT
      Z2_PLOT = Z2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


