C
C------------------------------------------------------
C
C     Problem:    TRANSDER
C
C     Date:       9.7.1997
C
C------------------------------------------------------
C
*     REAL CONSTANT
      y0 = 10
      VD = 10 
      VA = 1000
      F = 100
      k = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first space derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second space derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. space variable (x)
C     7. time variable (t)
C
*     VARIABLE
      D1, D2, kel, u, u_x, u_xx, y1, y2, y3, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_p
      u1_p = D1*u_xx
C
*     FUNCTION u2_p
      u2_p = D2*u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 0
C
*     FUNCTION u2_0
      u2_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
c
*     FUNCTION y1_p
      y1_p = D1*F*u_x
C
*     FUNCTION y2_p
      y2_p = -D2*F*u_x-kel*y2
C
*     FUNCTION y3_p
      y3_p = kel*y2
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION y1_0
      y1_0 = y0
C
*     FUNCTION y2_0
      y2_0 = 0
C
*     FUNCTION y3_0
      y3_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u1_left
      u1_left = y1/Vd
C
*     FUNCTION u2_left
      u2_left = k*u
C
*     FUNCTION u2_right
      u2_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u2_x_left
      u2_x_left = D1/D2*u_x 
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = y1
C
*     FUNCTION fit2
      fit2 = y2
C
*     FUNCTION fit3
      fit3 = y3/Va
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
