C
C------------------------------------------------------
C
C     Problem:    TOPTCSTR
C
C     Date:       28.11.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k11, k12, k21, k22, x1, x2, x3, x4, E, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      R1 = (x2 + 0.5)*exp(E*x2/(x2+2))
      u1 = k11*x2 + k12*x4
      x1_t =  0.5 - x1 - R1
C
*     FUNCTION x2_t
      x2_t = -2*(x2 + 0.25) - u1*(x2 + 0.5) + R1 
C
*     FUNCTION x3_t
      R2 = (x3 + 0.25)*exp(E*x4/(x4+2))
      u2 = k21*x2 + k22*x4
      x3_t =  x1 - x2 - R2 + 0.25
C
*     FUNCTION x4_t
      x4_t = x2 - 2*x4 - u2*(x4 + 0.25) + R2 - 0.25
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = -0.15
C
*     FUNCTION x2_0
      x2_0 = 0.05
C
*     FUNCTION x3_0
      x3_0 = -0.1
C
*     FUNCTION x4_0
      x4_0 = 0.02
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x_fit
      x_fit = abs(x1) + abs(x2) + abs(x3) + abs(x4)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
