C
C------------------------------------------------------
C
C     Problem:    TOLUENE
C
C     Date:       27.05.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, k5, x10, x20, x1, x2, x3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      thetaA = k4*x1/(k4*x1 + x2 + k5*x3)
      thetaB = x2/(k4*x1 + x2 + k5*x3)
      r1 = k1*thetaA
      rm1 = k2*thetaB
      r2 = k3*thetaB
      x1_t = -r1 + rm1
C
*     FUNCTION x2_t
      x2_t = -rm1 + r1 - r2
C
*     FUNCTION x3_t
      x3_t = r2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = x10
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




