C
C------------------------------------------------------
C
C     Problem:     TITRATIO
C
C     Date:        29.1.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      k4 = 20
      k5 = 13.685
      k6 = 0.09975
      k7 = 0.09658
C
C------------------------------------------------------
C
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. system variables (y)
C     3. time variable (t)
C
*     VARIABLE
      x1, x2, x3, y1, y2, y3, y4, beta, x
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      g1 = x3*k4 - (y2 + y3 + y4)*(k4 + x)
C
*     FUNCTION g2
      g2 = (1 + (beta*y3 + 2*beta*y4 - 10**(-(k5 - y1)))*10**y1)
     /           *(k4 + x) - beta*k6*x*10**y1
C
*     FUNCTION g3
      g3 = y1 - beta*y3*x1*10**y1
C
*     FUNCTION g4
      g4 = y3 - beta**3*y4*x2*10**y2
C
*     FUNCTION g5
      if (beta.gt.0) then
        alpha = 0.5*((2*k7*k4 + k6*x)/(k4 + x) 
     /          + 10**(-(k5 - y1))/beta + 10**(-y1)/beta
     /          + y3 + y4)
        if (alpha.lt.0) then
          alpha = 0.00000001
        endif
        g5 = log10(beta) - (-0.519*(sqrt(alpha)/(1+sqrt(alpha))
     /          - 0.2*alpha))
      else
        g5 = 0
      endif  
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION y1_0
      y1_0 = 10
C
*     FUNCTION y2_0
      y2_0 = 1
C
*     FUNCTION y3_0
      y3_0 = 1
C
*     FUNCTION y4_0
      y4_0 = 0.0001
C
*     FUNCTION beta_0
      beta_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit1
      fit1 = y1
C
*     FUNCTION fit2
      fit2 = y2
C
*     FUNCTION fit3
      fit3 = y3
C
*     FUNCTION fit4
      fit4 = y4
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

