C
C------------------------------------------------------
C
C     Problem:    TIME_OPT
C
C     Date:       05.01.98
C
C------------------------------------------------------
C
*     PARAMETER
      n = 5
      n1 = 4
C
C------------------------------------------------------
C
*     INDEX 
      i
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..n
      ind1 = 1..n1
      ind9 = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      alpha = 0.01
      eps = 0.00001
C
C------------------------------------------------------
C
*     MACRO s
      if (t.le.tb(1)) then
        s = 1
        goto 1000
      endif
      i = 2
  100 continue
      if ((t.le.tb(i+1)).and.(t.gt.tb(i))) then
        s = 1
        goto 1000
      endif
      i = i+2
      if (i.lt.n) then
        goto 100
      endif
      s = -1
 1000 continue
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      ts
      tb(j), j in ind
      u, u_x, u_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: differential
C     followed by algebraic functions in first area, then
C     differential followed by algebraic functions in 
C     second area, etc.):
C
*     FUNCTION u_t
      u_t = ts*u_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: initial values for 
C     differential followed by algebraic variables in 
C     first area, then differential followed by algebraic
C     variables in second area, etc.):
C
*     FUNCTION u_0
      if (t.eq.0) then
        u_0 = 0
      else
        u_0 = u
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u_left
c      u_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an areas, etc.:
C
*     FUNCTION u_x_left
      u_x_left = 0
C
*     FUNCTION u_x_right
      u_x_right = s - u
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(j), j in ind9
      fit(j) = u - (0.5 - 0.5*(0.1*j)**2)
C
*     FUNCTION fit_ts
      fit_ts = sqrt(alpha*ts)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g(j), j in ind1
      g(j) = tb(j+1) - tb(j) - eps
C
*     FUNCTION gn
      i = n
      gn = ts*(1 - tb(i)) - eps 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

