C
C------------------------------------------------------
C
C     Problem:    THERM
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      CP = 1 
      RHO = 1
      UA = 1.356E-03 
      HR = -10   
      T0 = 300   
      TJ = 305   
      Z = 8.03E+12
      R = 1.987  
      E = 22500  
      A0 = 5
      TR0 = 325 
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F, V, A, TR, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION AP
      K0 = Z*EXP(-E/(R*273))
      K = K0*EXP(-E/R*(1/TR - 1/273))
      AP = F*(A0 - A)/V-K*A
C
*     FUNCTION TRP
      XA = (A0 - A)/A0  
      HL = F*(TR - T0)/V + UA*(TR - TJ)/(V*RHO*CP)  
      HG = -K*A*HR/(CP*RHO)   
      TRP = HG - HL 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION A_0
      A_0 = A0
C
*     FUNCTION TR_0
      TR_0 = TR0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION AFIT
      AFIT = A
C
*     FUNCTION TRFIT
      TRFIT = TR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
