C
C------------------------------------------------------
C
C     Problem:    TEST_0DE
C
C     Date:       27.09.2001
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a, b, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y_t
      if (y.gt.0) then
        y_t = ((a*log(y) + b)/(t + 2) - 5)*y
      else
        y_t = 0
      endif
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0
      y_0 = 1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y_fit
      y_fit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

