C
C------------------------------------------------------
C
C     Problem:    TEMPCONT
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V=100
      F=10
      RHO=1
      CP=1  
      Q0=6
      TI=5
      TS=80   
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KP, T0, TR, INTG, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION TRP
      E=(TS-TR)   
      Q=Q0+KP*E+(KP/TI)*INTG 
      IF (Q.LT.0.0) THEN
        Q=0
      ENDIF
      TRP=(F/V)*(T0-TR)+Q/(V*RHO*CP)  
C
*     FUNCTION INTGP
      INTGP=E
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TR_0
      TR_0=T0
C
*     FUNCTION INTG_0
      INTG_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TR_fit
      TR_fit=TR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
