C
C------------------------------------------------------
C
C     Problem:    TEFLON2
C
C     Date:       19.04.2002
C
C------------------------------------------------------
C
*     REAL CONST
      B = 1.0E+6
      epsdot = 1/600
      CE = 690
      CB = 16.6
      YP = 26.1
      kappaD = 7.528
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      eta0, Z, kappa0, epsp, epsv, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION epsp_t
      if (t.lt.48) then
        eps = t*epsdot
      else 
        eps = 48*epsdot
      endif 
      sigma = CE*(eps - epsp - epsv)
      epsp_t = sigma*epsdot/(YP*1E9)
C
*     FUNCTION epsv_t
      kappa = (kappa0 + kappaD*tanh(B*epsdot))*1E6 
      sigmaB = CB*epsv
      eta = eta0*1E8*(1 + kappa*epsv)*exp(-Z*abs(sigma-sigmaB))
      if (eta.gt.0) then
        epsv_t = (sigma - sigmaB)/eta
      else
        epsv_t = 0
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION epsp_0
      if (t.lt.1) then
        epsp_0 = 0
      else
        epsp_0 = epsp
      endif
C
*     FUNCTION epsv_0
      if (t.lt.1) then
        epsv_0 = 0
      else
        epsv_0 = epsv
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      if (t.lt.48) then
        eps = t*epsdot
      else 
        eps = 48*epsdot
      endif 
      sigma = CE*(eps - epsp - epsv)
      fit = sigma
C
*     FUNCTION epsp_fit
      epsp_fit = epsp
C
*     FUNCTION epsv_fit
      epsv_fit = epsv
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




