C
C------------------------------------------------------
C
C     Problem:    TANKHYD
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
C      A1=1
C      A2=0.5 
      L=100
C      D=0.3   
      F=0.005 
      H10=1.5
      H20=1.2
      G=9.81
      PI=3.142
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A1, A2, D, H1, H2, FLOW, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION H1P
      H1P=-FLOW/A1
C
*     FUNCTION H2P
      H2P=FLOW/A2 
C
*     FUNCTION FLOWP
      TERM1=PI*D*D*G/(4*L)
      TERM2=F*8/(PI*D*D*D)
      FLOW2=FLOW*ABS(FLOW)
      FLOWP=TERM1*(H1-H2)-TERM2*FLOW2 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION H1_0
      H1_0=H10
C
*     FUNCTION H2_0
      H2_0=H20
C
*     FUNCTION FLOW_0
      FLOW_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION H1_fit
      H1_fit=H1
C
*     FUNCTION H2_fit
      H2_fit=H2
C
*     FUNCTION FLOW_fit
      FLOW_fit=FLOW
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
