C
C------------------------------------------------------
C
C     Problem:    TANKDIS
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      D=2.5
      DT=0.05
      L=0.05
      F=0.009
      PI=3.14
      MI=4.5E4
      P1=1E4
      P2=0
      G=9.81
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      RHO, M, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION MP
      ATANK = PI*D*D/4
      IF (M.LT.0) THEN
        MP=0
      ELSE
        H=M/(ATANK*RHO)+L
        ANOZZLE=PI*DT*DT/4
        V=SQRT((G*H+(P1-P2)/RHO)/(0.5+2*F*L/DT))
        W=ANOZZLE*RHO*V
        MP=-W
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION M_0
      M_0=MI
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION H_fit
      ATANK = PI*D*D/4
      H=M/(ATANK*RHO)+L
      H_fit=H
C
*     FUNCTION M_fit
      M_fit=M
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
