C
C------------------------------------------------------
C
C     Problem:    TANKBLD
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      F3=3   
      RHO=62.4
      B=0.6
      VMIN=0.05
      VMAX=20 
      V0=2
      C30=0 
      C3=C30 
      RHO30=RHO+B*C30  
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F1, F2, VRHO3, VC3, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION VRHO3P
      IF (T.LT.3) THEN
        C1=5
        C2=15
      ELSE
        C1=0
        C2=0
      ENDIF
      RHO1=RHO+B*C1 
      RHO2=RHO+B*C2  
      RHO3=RHO+B*C3  
      VRHO3P=(F1*RHO1+F2*RHO2-F3*RHO3)   
C
*     FUNCTION VC3P
      VC3P=(F1*C1+F2*C2-F3*C3)   
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION VRHO3_0
      IF (T.LT.0.1) THEN
        VRHO3_0=V0*RHO30
      ELSE
        VRHO3_0=VRHO3
      ENDIF
C
*     FUNCTION VC3_0
      IF (T.LT.0.1) THEN
        VC3_0=V0*C30 
      ELSE
        VC3_0=VC3
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C3_fit
      V=VRHO3/RHO3
      IF (V.LE.VMIN) THEN
        V=VMIN
      ENDIF
      C3_fit=VC3/V
C
*     FUNCTION VRHO3_fit
      VRHO3_fit=VRHO3
C
*     FUNCTION VC3_fit
      VC3_fit=VC3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
