C
C------------------------------------------------------
C
C     Problem:    TANK
C
C     Date:       23.01.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V=1000       
      CAI=0      
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k, CA0, Ca1, n, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Ca1p
      IF (t.LT.2) THEN
        F=1E5
      ELSE
        F=1E3
      ENDIF
      TAU=V/F
      IF (n.GT.0) THEN
        IF (CA1.GT.0) THEN
          Ra=-k*CA1**n   
        ELSE
          Ra=-k
        ENDIF
      ELSE
        Ra=-k
      ENDIF
      CA1p=1/TAU*(CA0-CA1)+Ra
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Ca1_0
      IF (t.LT.0.1) THEN
        Ca1_0 = Cai
      ELSE
        Ca1_0 = Ca1
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Ca1FIT
      Ca1FIT = Ca1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
