C
C----------------------------------------------------------------
C
C     Problem:   TAB_DIS8
C
C     Date:      11.4.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      cs = 100
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a10, a11, a12, a13, c1e
      a20, a21, a22, a23, c2e
      a30, a31, a32, c3e
      a40, a41, a42, c4e
      a50, a51, a52, a53, c5e
      c1, c2, c3, c4, c5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION c1p
      if (t.gt.0) then
        frate1 = a10 + a11/t*exp(-a12*(log(t) - a13)**2)
      else
        frate1 = a10
      endif
      c1p = frate1*cs*(1 - c1/c1e)
C
*     FUNCTION c2p
      frate2 = a20 + a21*exp(-a22*(t - a23)**2)
      c2p = frate2*cs*(1 - c2/c2e)
C
*     FUNCTION c3p
      if (t.gt.0) then
        frate3 = a30 + t**(a31-1)*exp(-t/2)/(2**a31*a32)
      else
        frate3 = a30
      endif
      c3p = frate3*cs*(1 - c3/c3e)
C
*     FUNCTION c4p
      if (t.gt.0) then
        frate4 = a40 + a41*a42*t**(a41-1)*exp(-a42*t**a41)
      else
        frate4 = a40
      endif
      c4p = frate4*cs*(1 - c4/c4e)
C
*     FUNCTION c5p
      frate5 = a50 + a51*a53/(a51-a52)*exp(-a52*t)*(exp(-a52*t) 
     /                                           - exp(-a51*t))
      c5p = frate5*cs*(1 - c5/c5e)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c10
      c10 = 0
C
*     FUNCTION c20
      c20 = 0
C
*     FUNCTION c30
      c30 = 0
C
*     FUNCTION c40
      c40 = 0
C
*     FUNCTION c50
      c50 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION c1fit
      c1fit = c1
C
*     FUNCTION c2fit
      c2fit = c2
C
*     FUNCTION c3fit
      c3fit = c3
C
*     FUNCTION c4fit
      c4fit = c4
C
*     FUNCTION c5fit
      c5fit = c5
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
