C
C----------------------------------------------------------------
C
C     Problem:   TAB_DIS4
C
C     Date:      11.4.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      cs = 100
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a0, a1, a2, a3, ce, c, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION cp
      frate = a0 + a1*exp(-a2*(t - a3)**2)
      cp = frate*cs*(1 - c/ce)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION c0
      c0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION cfit
      cfit = c
C
*     FUNCTION rate
      rate = a0 + a1*exp(-a2*(t - a3)**2)*(1 - c/ce)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


