C
C---------------------------------------------------------------
C
C     Problem:    TAB_DIS2
C
C     Date:       28.09.94
C
C---------------------------------------------------------------
C
*     PARAMETER
      N=4
C
C------------------------------------------------------
C
*     INDEX
      I
C
C------------------------------------------------------
C
*     SET OF INDICES
      INDEX=3..N
C
C------------------------------------------------------
C
*     REAL CONSTANT
      PI=4*ATAN(1)
      LOG2=LOG(2)
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      K1, te, ys, a0, Y1, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      LG1=LOG(SQRT(PI))
      LG2=0
      I=3
 1    CONTINUE
      LG=LOG((I-2)*0.5) + LG1
      I=I+1
      LG1=LG2
      LG2=LG
      IF (I.LT.N) THEN
        GOTO 1
      ENDIF
      IF (T.EQ.0) THEN
        CHI2=0
      ELSE
        CHI2=EXP((0.5*N-1)*LOG(T) - 0.5*T - LG - N*0.5*LOG2)
      ENDIF
      Y1P =(A0 + CHI2)*k1*(ys-y1)*(1-t/te)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      Y10 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Y1FIT
      Y1FIT = Y1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C





