C
C----------------------------------------------------------------
C
C     Problem:   TAB_DIS1
C
C     Date:      21.10.1994
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a1, a2, a3, t0, te, ys, tlag, y, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION yp
      if (t.le.tlag) then
        yp = 0
      else 
        ver = (a2/(t - tlag))*exp(-a3*(log(t - tlag) - t0)**2)
        yp = (a1 + ver)*(ys - y) *(1 - y/te)
      endif
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y0
      y0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION yfit
      yfit = y
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g
C      g = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C







