C
C------------------------------------------------------
C
C     Problem:     SULPHUR
C
C     Date:        30.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT 
      a2  = 77.3
      a4  = 105128
      b3  = 0.17
      c2  = 0.5
      x20 = 1700
      s   = 10000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      a1, a3, b1, c1, x1, x2, x3, b2
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      g1 = (x2*(a1*x1 + a2) - a3*s*x1 - a4)/a4
C
*     FUNCTION g2
      if (x2.gt.0) then
        g2 = exp(b1*s/x2 - b2 + b3*log(x2)) - x3
      else
        g2 = 0
      endif
C
*     FUNCTION g3
      g3 = (c1 - c2*x1)*(1 - x1)**2*x3 - x1**2*(10*c1 - c2*x1)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION x1_0
      x1_0 = 0.53
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = exp(b1*s/x20 - b2 + b3*log(x20))
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
