C
C------------------------------------------------------
C
C     Problem:    SULFUR
C
C     Date:       6.7.2000
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F4, F8, F9, V1, V2, V3, V4, V5, x20, x1, x2, x3, x4, x5, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = -F9/V1*x1 + F9/V5*x5
C
*     FUNCTION x2_t
      x2_t = F9/V1*x1 - (F4 - F8 + 2*F9)/V2*x2 + (-F8 + F9)/V3*x3
C
*     FUNCTION x3_t
      x3_t = (-F8 + F9)/V2*x2 - (-F8 + F9)/V3*x3
C
*     FUNCTION x4_t
      x4_t = F9/V2*x2 - F9/V4*x4
C
*     FUNCTION x5_t
      x5_t = F9/V4*x4 - F9/V5*x5
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0 
C
*     FUNCTION x2_0
      x2_0 = x20
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = 0
C
*     FUNCTION x5_0
      x5_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit1
      fit1 = x2
C
*     FUNCTION fit2
      fit2 = x3
C
*     FUNCTION fit3
      fit3 = x3
C
*     FUNCTION fit4
      fit4 = x3
C
*     FUNCTION fit5
      fit5 = x4
C
*     FUNCTION fit6
      fit6 = x5
C
*     FUNCTION fit7
      fit7 = x1
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g
      g = -F8 + F9
C
C     FUNCTION F10
C      F10 = F4 - F8 + 2*F9
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
