C----------------------------------------------------------------
C
C------------------------------------------------------
C
C     Problem:    SUB_ACCU
C
C     Date:       28.10.1995
C
C------------------------------------------------------
C
*     PARAMETER
      n=5
C
C------------------------------------------------------
C
*     REAL CONSTANT
      x10=25.0
      x20=0.2
      x30=0.094
      R=8.9
      pi=3.1415
      temp = 295
      k1p = 4.49E-05
      k2p = 5.78E-02
      k3p = 1.00E-08
      k3m = 1.13E+01
C
C------------------------------------------------------
C
*     SET OF INDICES
      indneg=2*k-1, k=1..n
      indpos=2*k, k=1..n
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      l, c1, d0, Ea, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1p
      a=l**2/(d0*exp(-Ea/(R*temp)))
      DIFFt=c1*l*(t/a - 1 + 2/pi**2
     /    *(sum(exp(-pi**2*j**2*t/a)/j, j in indpos)
     /     -sum(exp(-pi**2*j**2*t/a)/j, j in indneg)))
      x1t=x10 - y1 - y3
      x2t=x20 + DIFFt - y1
      x3t=x30 - y2
      y1p=k1p*x1t*x2t 
C
*     FUNCTION y2p
      y2p=k2p*y1*x3t
C
*     FUNCTION y3p
      y3p=k3p*y1*x1t - k3m*y3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y10
      y10=0.0
C
*     FUNCTION y20
      y20=0.0
C
*     FUNCTION y30
      y30=0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1fit
      y1fit=y2
C
*     FUNCTION y2fit
      y2fit=y2
C
*     FUNCTION y3fit
      y3fit=y2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
