C
C------------------------------------------------------
C
C     Problem:    SUBTILIS
C
C     Date:       27.07.99
C
C------------------------------------------------------
C 
*     REAL CONSTANT 
      ME0   = 100.0    
      KLA   = 400.0  
      DOSET = 3.0    
      BETABU = 0.20     
      MUE1   = 1.47      
      MUE2   = 0.354     
      KS     = 0.50      
      KC1    = 7.92E-2   
      KC2    = 6.02E-2   
      KRP1   = 2.34E-2   
      YSM    = 0.516     
      YC1M   = 1.88E-2  
      YC2M   = 9.57E-2  
      QL1MAX = 1.1E-3    
      KDOQL1 = 3.0      
      KDO    = 0.10      
      KIAC   = 23.0      
      EXPAC  = 3.0       
      KIBU   = 65.0      
      EXPBU  = 3.0       
      KPROD  = 4.0       
      ACBUM  = 9.0       
      Y21    = 0.711     
      Y23    = 0.440     
      Y24    =-0.174    
      KACBU  = 0.1       
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      D, FMP, X, S, AC, BU, C1, C2, DOX, BETAAC, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C 
*     FUNCTION X_t 
      S0 = ME0*YSM                       
      C10 = ME0*YC1M                      
      C20 = ME0*YC2M                     
      F0 = S/(KS+S)                      
      F1 = MUE1*C1/(KC1+C1)             
      F2 = MUE2*C2/(KC2+C2+abs(C1/KRP1)**2) 
      FIAC = 1/(1+abs(AC/KIAC)**EXPAC)       
      FIBU = 1/(1+abs(BU/KIBU)**EXPBU)        
      FACBU = ACBUM*abs(DOX)**2/(KPROD+abs(DOX)**2)  
      MUE = F0 * (F1+F2) * FIAC * FIBU * DOX/(KDO+DOX)
      QL1 = QL1MAX * DOX/(KDOQL1+DOX)
      QL2 = MUE/24.6/6
      IF (QL2 .LT. (Y21*QL1)) THEN
        QL1 = (QL2/Y21-1.0E-8)
      ENDIF  
      QL4 = KACBU*(AC-BU*FACBU)/X
      QL3 = (QL2 - Y21*QL1 - Y24*QL4)/Y23
      QS = (QL1 + QL2 + QL3)
      RS = QS * X
      RX = 6*QL2 * X
      RAC = (QL3-QL4) * X
      RBU = QL4 * X
      OUR = (6*QL1 - 0.3*QL2 + QL3 - 0.5*QL4) * X
      CPR = (6*QL1 + 2*QL3) * X
      RC1 = F1/(F1+F2) * RX
      RC2 = F2/(F1+F2) * RX
      DPU = D/(1 + FMP)     
      DPE = D - DPU         
      ACPE = AC*BETAAC  
      BUPE = BU*BETABU 
      X_T    = 24.6*RX - X*DPU
C 
*     FUNCTION S_t
      S_t = S0*D - S*DPU - 180*RS
C 
*     FUNCTION AC_t
      AC_t = 88*RAC - AC*DPU - ACPE*DPE 
C 
*     FUNCTION BU_t
      BU_t = 90*RBU - BU*DPU - BUPE*DPE
C 
*     FUNCTION C1_t
      C1_t = C10*D - C1*DPU - 24.6*RC1  
C 
*     FUNCTION C2_t
      C2_t =  C20*D - C2*DPU - 24.6*RC2  
C 
*     FUNCTION DOX_t
      DOX_t =  (100 - DOX)*KLA - OUR*100/2.344E-4 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X_0 
      X_0 = 0.1       
C
*     FUNCTION S_0
      S_0 = ME0*YSM
C
*     FUNCTION AC_0
      AC_0 = 0.01
C
*     FUNCTION BU_0
      BU_0 = 0.01
C
*     FUNCTION C1_0
      C1_0 = ME0*YC1M
C
*     FUNCTION C2_0
      C2_0 = ME0*YC2M
C
*     FUNCTION DOX_0
      DOX_0 = DOSET
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION ACPE_FIT
      ACPE_FIT = AC*BETAAC  
C
*     FUNCTION BUPE_FIT
      BUPE_FIT = BU*BETABU 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
