C
C------------------------------------------------------
C
C     Problem:    STIFF1
C
C     Date:       16.01.00
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      beta1, beta2, beta3, y1, y2, y3, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -beta1*y1 + y1**2
C
*     FUNCTION y2_t
      y2_t = -beta2*y2 + y2**2
C
*     FUNCTION y3_t
      y3_t = -beta3*y3 + y3**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y1_0
      y1_0 = -1
C
*     FUNCTION y2_0
      y2_0 = -1
C
*     FUNCTION y3_0
      y3_0 = -1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
c      c1 = -(1 + beta1)
c      y1_fit = beta1/(1 + c1*exp(beta1*t))
      y1_fit = y1
C
*     FUNCTION y2_fit
c      c2 = -(1 + beta2)
c      y2_fit = beta2/(1 + c2*exp(beta2*t))
      y2_fit = y2
C
*     FUNCTION y3_fit
c      c3 = -(1 + beta3)
c      y3_fit = beta3/(1 + c3*exp(beta3*t))
      y3_fit = y3
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
