C
C------------------------------------------------------
C
C     Problem:    STIFF
C
C     Date:       28.09.98
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k3, k4, k5, k6
      y1, y2, y3, y4, y5, y6, y7, y8, y9, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION y1_t
      y1_t = -k1*y1 + 900*y2
C
*     FUNCTION y2_t
      y2_t = y1 - k3*y2 + y3  
C
*     FUNCTION y3_t
      y3_t = y2 - k3*y3 + y4
C
*     FUNCTION y4_t
      y4_t = y3 - k3*y4 + y5
C
*     FUNCTION y5_t
      y5_t = y4 - k3*y5 + y6
C
*     FUNCTION y6_t
      y6_t = y5 - k3*y6 + y7
C
*     FUNCTION y7_t
      y7_t = y6 - k3*y7 + y8
C
*     FUNCTION y8_t
      y8_t = y7 - k3*y8 + y9
C
*     FUNCTION y9_t
      y9_t = k4*y8 - k5*y9 + k6
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION y_0(i), i IN ind
      y_0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = y1
C
*     FUNCTION y2_fit
      y2_fit = y2
C
*     FUNCTION y3_fit
      y3_fit = y3
C
*     FUNCTION y4_fit
      y4_fit = y4
C
*     FUNCTION y5_fit
      y5_fit = y5
C
*     FUNCTION y6_fit
      y6_fit = y6
C
*     FUNCTION y7_fit
      y7_fit = y7
C
*     FUNCTION y8_fit
      y8_fit = y8
C
*     FUNCTION y9_fit
      y9_fit = y9
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C






