C
C------------------------------------------------------
C
C     Problem:    STEP_RES
C
C     Date:       16.12.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      K = 2.5
      theta = 0.5
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. concentration variable, if exists (c)
C     3. time variable (t)
C
*     VARIABLE
      z, T, a, time
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION G
      z2 = sqrt(1-z**2)
      t1 = time - theta
      if (t1.lt.0) then
        t1 = 0
      endif
      G = a + K*(1 - exp(-z*t1/T)/z2)
     /            *(z*sin(z2/T*t1) + z2*cos(z2/T*t1))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




