C
C------------------------------------------------------
C
C     Problem:    STEPHAN
C
C     Date:       29.09.97
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..9
C
C------------------------------------------------------
C
*     REAL CONSTANT
      t0 = 1.0E-4
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, u, u_x, u_xx, v, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_t
      if ((t.lt.t0).or.(v.eq.0)) then   
        u_t = 0
      else
        u_t = b*(u_xx + v*x*u_x)/v**2
      endif
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0
      if (t.lt.t0/2) then
        u_0 = 0
      else
        u_0 = exp(t0*(1 - x)) - 1
      endif
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION v_t
      if ((t.lt.t0).or.(v.eq.0)) then
        v_t = 0
      else
        v_t = -a*u_x/v 
      endif
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION v_0
      if (t.lt.t0/2) then
        v_0 = 0
      else
        v_0 = t0
      endif
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_right
      u_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION u_x_left
      if (t.lt.t0) then   
        u_x_left = 0
      else
        u_x_left = -v*exp(t)
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit_u(i), i in ind
      fit_u(i) = u 
c      fit_u(i) = exp(t*(1 - x)) - 1
C
*     FUNCTION fit_v
      fit_v = v 
c      fit_v = t 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
