C
C------------------------------------------------------
C
C     Problem:    STAT5
C
C     Date:       20.05.2003
C
C------------------------------------------------------
C                     
*     LININT EpoR
      0.0   0.0
      2.5   9.0
      5.0  12.0
      7.5  45.0
      10.0 58.0
      12.5 50.0
      15.0 33.0
      17.5 35.0
      20.0 20.0
      25.0 18.0
      30.0  3.0
      40.0  2.0
      50.0  1.0
      60.0  0.5
C
C------------------------------------------------------
C                     
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, x1, x2, x3, x4, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = -k1*x1*EpoR(t)
C
*     FUNCTION x2_t
      x2_t = k1*x1*EpoR(t) - k2*x2**2
C
*     FUNCTION x3_t
      x3_t =  0.5*k2*x2**2 - k3*x3
C
*     FUNCTION x4_t
      x4_t =  k3*x3
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0.6
C
*     FUNCTION x2_0
      x2_0 = 0
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION y1_fit
      y1_fit = x2 + 2*x3
C
*     FUNCTION y2_fit
      y2_fit = x1 + x2 + 2*x3
C
*     FUNCTION x1_fit
      x1_fit = x1 
C
*     FUNCTION x2_fit
      x2_fit = x2 
C
*     FUNCTION x3_fit
      x3_fit = x3 
C
*     FUNCTION x4_fit
      x4_fit = x4 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
