C
C------------------------------------------------------
C
C     Problem:    STAR_NET
C
C     Date:       12.12.97
C
C------------------------------------------------------
C
*     PARAMETER
      n = 3
C
C------------------------------------------------------
C
*     SET OF INDICE2S
      ind = 1..n
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u0 = 0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a(i), i in ind
      u(i), i in ind
      u_x(i), i in ind
      u_xx(i), i in ind
      v
      x,t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = U
C
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_p(i), i in ind
      u_p(i) = a(i)*u_xx(i)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION u_0(i), i in ind
      u_0(i) = u0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
*     FUNCTION v_p
      v_p = sum(a(i)*u_x(i), i in ind)
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
*     FUNCTION v_0
      v_0 = u0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION u_left(i), i in ind
      u_left(i) = v
C
*     FUNCTION u1_right
      u1_right = sin(t)
C
*     FUNCTION u2_right
      u2_right = 0
C
*     FUNCTION u3_right
      u3_right = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
C
C*     FUNCTION UXL
C      UXL = ...
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION u1_fit
      u1_fit = u_x(1)
C
*     FUNCTION u2_fit
      u2_fit = u_x(2)
C
*     FUNCTION u3_fit
      u3_fit = u_x(3)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
