C
C------------------------------------------------------
C
C     Problem:    STARTUP
C
C     Date:       02.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      pi = 3.1415926535
c
      rpar1  =     60.0
      rpar2  =     62.0
      rpar3  =      0.0
      rpar4  =      0.0
      rpar5  =      0.0
      rpar6  =      0.656
      rpar7  =   2622.0
      rpar8  =  55050.0
      rpar9  =      0.0
      rpar10 =      0.0
      rpar11 =      0.0
      rpar12 =      1.0E-03
      rpar13 =      1.08966
      rpar14 =      0.0
      rpar15 =      0.0
      rpar16 =      0.0
      rpar17 =      1.1
      rpar18 =    659.0
      rpar19 =      8.5E-04
      rpar20 =      0.0
      rpar21 =      0.0
      rpar22 =      0.0
      rpar23 =      0.45
      rpar24 =   7150.0
      rpar25 =      1.3E-02
      rpar26 =      1.0
      rpar27 =      1.0
      rpar28 =      0.0
      rpar29 =     42.0
      rpar30 =      1.392E+12
      rpar31 =  14556.0
      rpar32 =   2080.0
      rpar33 =    361.0
      rpar34 =      1.928E+06
      rpar35 =      0.0
      rpar36 =      0.0
      rpar37 =      0.0
      rpar38 =     28.0
      rpar39 =      6.699E+10
      rpar40 =  12556.0
      rpar41 =     65.5
      rpar42 =    961.0
      rpar43 = 283200.0
      rpar44 =      0.0
      rpar45 =      0.0
      rpar46 =      0.0
      rpar47 =      2.0
      rpar48 = 242000.0
      rpar49 =      0.0
      rpar50 =      3.98
      rpar51 =  11611.0
      rpar52 =     32.0
      rpar53 =      0.0
      rpar54 =      0.0
      rpar55 =      0.0
      rpar56 =      0.156
      rpar57 =      0.2
      rpar58 =      0.9
      rpar59 =      0.265
      rpar60 =      0.0
      rpar61 =      0.0
      rpar62 =      0.0
      rpar63 =      5.0E-05
      rpar64 =      1.0E-04
      rpar65 =      3.0E-04
      rpar66 =      1.0E-04
      rpar67 =      0.0
      rpar68 =      0.0
      rpar69 =      0.0
      rpar70 =      1.0
      rpar71 =     20.0
      rpar72 =      0.0
      rpar73 =      0.0
      rpar74 =      0.0
      rpar75 =      5.0E-03
      rpar76 =      3.66
      rpar77 =      0.0
      rpar78 =      0.0
      rpar79 =      0.0
      rpar80 =      1.0E-03
      rpar81 =      0.0
      rpar82 =      0.0
      rpar83 =      0.0
      rpar84 =      2.0E-02
      rpar85 =      5.0E-02
      rpar86 =      1.0E-02
      rpar87 =      1.0E-03
      rpar88 =      1.0E-01
      rpar89 =      0.0
      rpar90 =      0.0
      rpar91 =      0.0
      rpar92 =     29.0
      rpar93 =      0.0
      rpar94 =      0.0
      rpar95 =    100.0
      rpar96 =      1.0E-04
      rpar97 =      6.7E-03
      rpar98 =      3.5E-04
      rpar99 =     20.0
      rpar100=    400.0
c
      r_i = rpar1/1000
      r_a = rpar2/1000
c
      eps_w = (r_a*r_a - r_i*r_i)/r_i/r_i
      eps_g = rpar6
      eps_k = 1 - eps_g
c
      xlam_g = rpar12
      xlam_k = rpar19
      xlam_w = rpar25
c
      d_eff_co   = rpar64
      d_eff_c3h6 = rpar63
      d_eff_h2   = rpar65
      d_eff_o2   = rpar66
c
      dval1 = eps_w*xlam_w
      dval2 = eps_g*xlam_g
      dval3 = eps_k*xlam_k
      dval5 = eps_g*d_eff_co
      dval4 = dval5
      dval7 = eps_g*d_eff_c3h6
      dval6 = dval7
      dval9 = eps_g*d_eff_h2
      dval8 = dval9
      dval11 = eps_g*d_eff_o2
      dval10 = dval11
c
      cp_w = rpar23
      cp_k = rpar17
      cp_g = rpar13
c
      rho_w = rpar24
      rho_k = rpar18
c
      pges = rpar70*1.0d5
      rr   = 8314           
c
      xmp  = rpar84
      GZ   = xmp/pi/r_i/r_i
c
      xm_luft = rpar92
      xm_co   = rpar38
      xm_c3h6 = rpar29
      xm_h2   = rpar47
      xm_o2   = rpar52
c
      xkz_co = rpar39
      xkn_co = rpar41
      ez_co  = rpar40
      en_co  = rpar42
c
      xkz_c3h6 = rpar30
      xkn_c3h6 = rpar32
      ez_c3h6  = rpar31
      en_c3h6  = rpar33
c
      xk_coc3h6 = rpar50
      e_coc3h6 =  rpar51
c
      xhr_co   = rpar43
      xhr_c3h6 = rpar34
      xhr_h2   = rpar48
c
      beta_co   = rpar57
      beta_c3h6 = rpar56
      beta_h2   = rpar58
      beta_o2   = rpar59
c
      av = rpar7
      ax = rpar8
c
      alpha_a = rpar75
      tu      = rpar71
      xnu     = rpar76
      d_h     = rpar80
c
      alpha_i = xnu*xlam_g/d_h/20
c
      D_BM    = rpar97
      XLAM_BM = rpar96
      A_H     = pi * r_i * r_i 
      XL      = 0.16d0 
      R_B     = 2/3 * r_i
      A_B     = PI * r_b * r_b
      XK_S    = RPAR98

      HILFA = log(r_i/r_b)       /(2.*PI*XK_S   *XL)
     2     + log((r_i + d_bm)/r_i) / (2.*PI*XLAM_BM*XL)
     3     + log((r_a + r_i)/2/r_i) /(2.*PI*XLAM_W *XL)
c
      HILFB =  1./(4. * PI * alpha_a * r_a * r_a)
     2     + log(2*r_a/(r_a + r_i)) /(2.*PI*XLAM_W *XL)
c
      xk_u = 1./HILFB / A_B
      xk_i = 1./HILFA / A_B 
c
      xfakhemm = rpar28
      xhoch    = rpar27
      xfako2   = rpar26
c
      w_co_zu   = rpar85
      w_c3h6_zu = rpar86
      w_h2_zu   = rpar87
      w_o2_zu   = rpar88
c
      temp_anfang = rpar99
      temp_ende   = rpar100
c
      t_steig = rpar95
c
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..11
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      s1, s2, s3
      u(i), i in ind
      ux(i), i in ind
      uxx(i), i in ind
      x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION u1_t
c
      TI    = u(2) + 273.15
      rho_g = PGES * XM_LUFT/(RR * TI)
c
      bmat1 = eps_w * rho_w * cp_w
      bmat2 = eps_g * rho_g * cp_g 
      bmat3 = eps_k * rho_k * cp_k
      bmat5 = eps_g * rho_g
      bmat4 = bmat5
      bmat7 = eps_g * rho_g
      bmat6 = bmat7
      bmat9 = eps_g * rho_g
      bmat8 = bmat9
      bmat11 = eps_g * rho_g
      bmat10 =  bmat11
c        
      conv1 = 0.0
      conv2 = gz*cp_g*ux(2) 
      conv3 = 0.0
      conv4 = 0.0 
      conv5 = gz *ux(5)
      conv6 = 0.0 
      conv7 = gz *ux(7)
      conv8 = 0.0 
      conv9 = gz *ux(9)
      conv10 = 0.0 
      conv11 = gz *ux(11)
C
      T_WAND = U(1)
      T_GAS  = U(2)
      T_KAT  = U(3)
      W_COS  = U(4)
      W_COG  = U(5)
      W_C3H6S= U(6)
      W_C3H6G= U(7)
      W_H2S  = U(8)
      W_H2G  = U(9)
      W_O2S  = U(10)
      W_O2G  = U(11)

      RHO_G = PGES * XM_LUFT/(RR * TI)
      Y_COS   = XM_LUFT/XM_CO   * W_COS
      Y_C3H6S = XM_LUFT/XM_C3H6 * W_C3H6S
      Y_H2S   = XM_LUFT/XM_H2   * W_H2S
      Y_O2S   = XM_LUFT/XM_O2   * W_O2S
c
      XXKZ_CO = XKZ_CO * DEXP(-EZ_CO/ TI)
      XXKN_CO = XKN_CO * DEXP( EN_CO/ TI)
      XXKZ_C3H6 = XKZ_C3H6 * DEXP(-EZ_C3H6/ TI)
      XXKN_C3H6 = XKN_C3H6 * DEXP( EN_C3H6/ TI)
      XXK_COC3H6 = XK_COC3H6 * DEXP( E_COC3H6/ TI)
c
      G1CO = 1 + xfakhemm * XXKN_CO * abs(Y_COS)
      G1HC = 1 + xfakhemm * XXKN_C3H6 * abs(Y_C3H6S)
c
      R_CO   = XXKZ_CO  * Y_COS * Y_O2S/ TI/G1CO**xhoch 
      R_C3H6 = XXKZ_C3H6 * Y_C3H6S * Y_O2S/ TI/G1HC**xhoch
      R_H2   = XXKZ_CO * Y_H2S*Y_O2S/TI/G1CO**xhoch
      R_O2   = 0.5*R_CO + 4.5*R_C3H6 + 0.5*R_H2
      R_O2   = xfako2*R_O2
c
      q1 = xk_i/r_i  * (T_KAT - T_WAND)
     2             - xk_u/r_i/r_i*r_a  * (T_WAND - tu) 
      q2 = alpha_i * av * (T_KAT - T_GAS)
      q3 = - xk_i/r_i * (T_KAT - T_WAND)
     2               - alpha_i * av * (T_KAT - T_GAS)
     3               + xhr_co * ax * 10. * R_CO
     4               + xhr_c3h6 * ax * 10. * R_C3H6
     5               + xhr_h2 * ax * 10. * R_H2
      q4 = rho_g * beta_co * av * (W_COG - W_COS)
     2               - 1.0 * ax * 10. * xM_CO * R_CO
      q5 = - rho_g * beta_co * av * (W_COG - W_COS)
      q6 = rho_g * beta_C3H6 * av * (W_C3H6G - W_C3H6S)
     2               - 1.0 * ax * 10. * xM_C3H6 * R_C3H6
      q7 = - rho_g * beta_C3H6 * av * (W_C3H6G - W_C3H6S)
      q8 = rho_g * beta_H2 * av * (W_H2G - W_H2S)
     2               - 1.0 * ax * 10. * xM_H2 * R_H2
      q9 = - rho_g * beta_H2 * av * (W_H2G - W_H2S)
      q10 = rho_g * beta_O2 * av * (W_O2G - W_O2S)
     2               - 1.0 * ax * 10. * xM_O2 * R_O2
      q11 = - rho_g * beta_O2 * av * (W_O2G - W_O2S)
c
      u1_t = (s1*dval1*uxx(1) - conv1 + q1)/bmat1
C
*     FUNCTION u2_t
      u2_t = (s2*dval2*uxx(2) - conv2 + q2)/bmat2
C
*     FUNCTION u3_t
      u3_t = (s3*dval3*uxx(3) - conv3 + q3)/bmat3
C
*     FUNCTION u4_t
      u4_t = (dval4*uxx(4) - conv4 + q4)/bmat4
C
*     FUNCTION u5_t
      u5_t = (dval5*uxx(5) - conv5 + q5)/bmat5
C             
*     FUNCTION u6_t
      u6_t = (dval6*uxx(6) - conv6 + q6)/bmat6
C
*     FUNCTION u7_t
      u7_t = (dval7*uxx(7) - conv7 + q7)/bmat7
C
*     FUNCTION u8_t
      u8_t = (dval8*uxx(8) - conv8 + q8)/bmat8
C
*     FUNCTION u9_t
      u9_t = (dval9*uxx(9) - conv9 + q9)/bmat9
C
*     FUNCTION u10_t
      u10_t = (dval10*uxx(10) - conv10 + q10)/bmat10
C
*     FUNCTION u11_t
      u11_t = (dval11*uxx(11) - conv11 + q11)/bmat11
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION u1_0
      u1_0 = 20
C
*     FUNCTION u2_0
      u2_0 = 20
C
*     FUNCTION u3_0
      u3_0 = 20
C
*     FUNCTION u4_0
      u4_0 = 0.05
C
*     FUNCTION u5_0
      u5_0 = 0.05
C
*     FUNCTION u6_0
      u6_0 = 0.01
C
*     FUNCTION u7_0
      u7_0 = 0.01
C
*     FUNCTION u8_0
      u8_0 = 0.001
C
*     FUNCTION u9_0
      u9_0 = 0.001
C
*     FUNCTION u10_0
      u10_0 = 0.1
C
*     FUNCTION u11_0
      u11_0 = 0.1
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION u1_left
c      u1_left = ...
C
c*     FUNCTION u_right
c      u_right = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION u1_x_left
      t_zu = t/t_steig*(temp_ende - temp_anfang) + temp_anfang
      if (t.gt.100) then
        t_zu = temp_ende
      endif
      alphal1 = 0.0 
      betal1  = -XLAM_w* EPS_w
      gammal1 = 0.0
      alphar1 = 0.0 
      betar1  = -XLAM_w* EPS_w
      gammar1 = 0.0
      alphal3 = 0.0 
      betal3  = -XLAM_k*EPS_k
      gammal3 = 0.0
      alphar3 = 0.0 
      betar3  = -XLAM_k*EPS_k
      gammar3 = 0.0
      alphal4 = 0.0 
      betal4  = 1.0
      gammal4 = 0.0
      alphar4 = 0.0 
      betar4  = 1.0
      gammar4 = 0.0
      alphal6 = 0.0 
      betal6  = 1.0
      gammal6 = 0.0
      alphar6 = 0.0 
      betar6  = 1.0
      gammar6 = 0.0
      alphal8 = 0.0 
      betal8  = 1.0
      gammal8 = 0.0
      alphar8 = 0.0 
      betar8  = 1.0
      gammar8 = 0.0
      alphal10 = 0.0 
      betal10  = 1.0
      gammal10 = 0.0
      alphar10 = 0.0 
      betar10  = 1.0
      gammar10 = 0.0
      alphal2 = gz*cp_g 
      betal2  = -eps_g*xlam_g
      gammal2 = gz*cp_g*t_zu
      alphar2 = 0.0 
      betar2  = -xlam_g*eps_g
      gammar2 = 0.0
      alphal5 = gz 
      betal5  = -D_eff_co*eps_g
      gammal5 = gz*w_co_zu
      alphar5 = 0.0 
      betar5  = -D_eff_co*eps_g
      gammar5 = 0.0
      alphal7 = gz 
      betal7  = -D_eff_c3h6*eps_g
      gammal7 = gz*w_c3h6_zu
      alphar7 = 0.0 
      betar7  = -D_eff_c3h6*eps_g
      gammar7 = 0.0
      alphal9 = gz 
      betal9  = -D_eff_h2*eps_g
      gammal9 = gz*w_h2_zu
      alphar9 = 0.0 
      betar9  = -D_eff_h2*eps_g
      gammar9 = 0.0
      alphal11 = gz 
      betal11  = -D_eff_o2*eps_g
      gammal11 = gz*w_o2_zu
      alphar11 = 0.0 
      betar11  = -D_eff_o2*eps_g
      gammar11 = 0.0
c
      u1_x_left = (gammal1 - alphal1*u(1))/betal1
C
*     FUNCTION u2_x_left
      u2_x_left = (gammal2 - alphal2*u(2))/betal2
C
*     FUNCTION u3_x_left
      u3_x_left = (gammal3 - alphal3*u(3))/betal3
C
*     FUNCTION u4_x_left
      u4_x_left = (gammal4 - alphal4*u(4))/betal4
C
*     FUNCTION u5_x_left
      u5_x_left = (gammal5 - alphal5*u(5))/betal5
C
*     FUNCTION u6_x_left
      u6_x_left = (gammal6 - alphal6*u(6))/betal6
C
*     FUNCTION u7_x_left
      u7_x_left = (gammal7 - alphal7*u(7))/betal7
C
*     FUNCTION u8_x_left
      u8_x_left = (gammal8 - alphal8*u(8))/betal8
C
*     FUNCTION u9_x_left
      u9_x_left = (gammal9 - alphal9*u(9))/betal9
C
*     FUNCTION u10_x_left
      u10_x_left = (gammal10 - alphal10*u(10))/betal10
C
C
*     FUNCTION u11_x_left
      u11_x_left = (gammal11 - alphal11*u(11))/betal11
C
*     FUNCTION u1_x_right
      u1_x_right = (gammar1 - alphar1*u(1))/betar1
C
*     FUNCTION u2_x_right
      u2_x_right = (gammar2 - alphar2*u(2))/betar2
C
*     FUNCTION u3_x_right
      u3_x_right = (gammar3 - alphar3*u(3))/betar3
C
*     FUNCTION u4_x_right
      u4_x_right = (gammar4 - alphar4*u(4))/betar4
C
*     FUNCTION u5_x_right
      u5_x_right = (gammar5 - alphar5*u(5))/betar5
C
*     FUNCTION u6_x_right
      u6_x_right = (gammar6 - alphar6*u(6))/betar6
C
*     FUNCTION u7_x_right
      u7_x_right = (gammar7 - alphar7*u(7))/betar7
C
*     FUNCTION u8_x_right
      u8_x_right = (gammar8 - alphar8*u(8))/betar8
C
*     FUNCTION u9_x_right
      u9_x_right = (gammar9 - alphar9*u(9))/betar9
C
*     FUNCTION u10_x_right
      u10_x_right = (gammar10 - alphar10*u(10))/betar10
C
*     FUNCTION u11_x_right
      u11_x_right = (gammar11 - alphar11*u(11))/betar11
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(i), i in ind
      fit(i) = u(i)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
