C
C------------------------------------------------------
C
C     Problem:    STARS
C
C     Date:       12.10.2006
C
C------------------------------------------------------
C                   
*     PARAMETER
      N = 10
C
C------------------------------------------------------
C                   
*     SET OF INDICES
      ind = 1..N
C
C------------------------------------------------------
C                   
*     REAL CONSTANT
      m = 1/N 
      eps = 1.0E-8
C
C------------------------------------------------------
C                   
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      G
      rx(i), i in ind
      ry(i), i in ind
      rz(i), i in ind
      vx(i), i in ind
      vy(i), i in ind
      vz(i), i in ind
      t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION rx_t(i), i in ind
      rx_t(i) = vx(i)
C
*     FUNCTION ry_t(i), i in ind
      ry_t(i) = vy(i)
C
*     FUNCTION rz_t(i), i in ind
      rz_t(i) = vz(i)
C
*     FUNCTION vx_t(i), i in ind
      vx_t(i) = G*m*sum((rx(j)-rx(i))/((rx(i)-rx(j))**2 + (ry(i)-ry(j))**2
     /       + (rz(i)-rz(j))**2 + eps)**(3/2), j in ind)
C
*     FUNCTION vy_t(i), i in ind
      vy_t(i) = G*m*sum((ry(j)-ry(i))/((rx(i)-rx(j))**2 + (ry(i)-ry(j))**2
     /       + (rz(i)-rz(j))**2 + eps)**(3/2), j in ind)
C
*     FUNCTION vz_t(i), i in ind
      vz_t(i) = G*m*sum((rz(j)-rz(i))/((rx(i)-rx(j))**2 + (ry(i)-ry(j))**2
     /       + (rz(i)-rz(j))**2 + eps)**(3/2), j in ind)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION rx_0(i), i in ind
      rx_0(i) = i - 1
C
*     FUNCTION ry_0(i), i in ind
      ry_0(i) = 2*i - 2
C
*     FUNCTION rz_0(i), i in ind
      rz_0(i) = 4*i - 4
C
*     FUNCTION vx_0(i), i in ind
      vx_0(i) = 0
C
*     FUNCTION vy_0(i), i in ind
      vy_0(i) = 0
C
*     FUNCTION vz_0(i), i in ind
      vz_0(i) = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION rx_fit
      rx_fit = rx(5)
C
*     FUNCTION ry_fit
      ry_fit = ry(5)
C
*     FUNCTION rz_fit
      rz_fit = rz(5)
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
