C
C------------------------------------------------------
C
C     Problem:    STAR
C
C     Date:       01.07.1994
C
C------------------------------------------------------
C
*     VARIABLE
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      A, B, C, X1, X2, X3, X4, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      X1P = X3
C
*     FUNCTION X2P
      X2P = X4
C
*     FUNCTION X3P
      X3P = -A*X1 - 2*X1*X2
C
*     FUNCTION X4P
      X4P = -B*X2 - X1**2 - C*X2**2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X10
      X10 = 0
C
*     FUNCTION X20
      X20 = 0
C
*     FUNCTION X30
      X30 = 0.3
C
*     FUNCTION X40
      X40 = -0.41
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION X4FIT
      X4FIT = X4
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
