C
C------------------------------------------------------
C
C     Problem:    STAGED
C
C     Date:       14.02.2001
C
C------------------------------------------------------
C
*     REAL CONSTANT
      V1=1
      V2=1.5
      F=0.5
      F1=0
      S0=10
      S10=10
      UM=0.6
      X0=0
      KI=2
      P10=0
      P0=0
      YPS=0.5
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      KS, Y, A0, B, X1, S1, P1, X2, S2, P2, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION X1P
      U1=UM*S1/(KS+S1+P1/KI)
      RX1=U1*X1
      A1=A0-A0*P1/(1+P1)
      RP1=(A1+B*U1)*X1 
      RS1=-RX1/Y-RP1/YPS
      X1P=F*(X0-X1)/V1+RX1
C
*     FUNCTION S1P
      S1P=F*(S0-S1)/V1+RS1
C
*     FUNCTION P1P
      P1P=F*(P0-P1)/V1+RP1
C
*     FUNCTION X2P
      U2=UM*S2/(KS+S2+P2/KI)
      RX2=U2*X2
      A2=A0-A0*P2/(1+P2)   
      RP2=(A2+B*U2)*X2
      RS2=-RX2/Y-RP2/YPS
      X2P=F*(X1-X2)/V2+RX2-F1*X2/V2
C
*     FUNCTION S2P
      S2P=F*(S1-S2)/V2+RS2+F1*(S10-S2)/V2
C
*     FUNCTION P2P
      P2P=F*(P1-P2)/V2+RP2+F1*(P10-P2)/V2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION X1_0
      X1_0=0.1
C
*     FUNCTION S1_0
      S1_0=S0
C
*     FUNCTION P1_0
      P1_0=0
C
*     FUNCTION X2_0
      X2_0=0
C
*     FUNCTION S2_0
      S2_0=S0
C
*     FUNCTION P2_0
      P2_0=0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION X1_fit
      X1_fit=X1
C
*     FUNCTION S1_fit
      S1_fit=S1
C
*     FUNCTION P1_fit
      P1_fit=P1
C
*     FUNCTION X2_fit
      X2_fit=X2
C
*     FUNCTION S2_fit
      S2_fit=S2
C
*     FUNCTION P2_fit
      P2_fit=P2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
