C
C------------------------------------------------------
C
C     Problem:    STABIL
C
C     Date:       1.02.2001
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      C0=0
      TEMP0=550
      W=1
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      TSET, C, TEMP, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION CP
      K=1e8*EXP(-10000/TEMP)
      CP=2*(0.2704-C)-K*C
C
*     FUNCTION TEMPP
      IF (T.LT.10) THEN
        A=0
      ELSE
        A=1
      ENDIF
      IF (T.LT.29) THEN
        KC=0
      ELSE
        KC=100
      ENDIF
      VAR=A*SIN(W*T)         
      U=KC*(TSET-TEMP)       
      TEMPP=2*(530-TEMP)+200*K*C-0.1*(TEMP-530)+2*VAR+0.1*U
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C_0
      IF (T.LT.1) THEN
        C_0 = C0  
      ELSE
        C_0 = C
      ENDIF
C
*     FUNCTION TEMP_0
      IF (T.LT.1) THEN
        TEMP_0 = TEMP0 
      ELSE
        TEMP_0 = TEMP
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TEMP_FIT
      TEMP_FIT = TEMP
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
