C
C------------------------------------------------------
C
C     Problem:    STABCSTR
C
C     Date:       28.11.2002
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, x1, x2, E, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      u = k1*x1 + k2*x2
      x1_t = (x2 + 0.5)*exp(E*x1/(x1+2)) - (2 + u)*(x1 + 0.25)
C
*     FUNCTION x2_t
      x2_t = 0.5 - x2 - (x2 + 0.5)*exp(E*x1/(x1+2)) 
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 0.1
C
*     FUNCTION x2_0
      x2_0 = 0.1
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x_fit
      x_fit = abs(x1) + abs(x2)
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
