C
C------------------------------------------------------
C
C     Problem:    SS_TUBE
C
C     Date:       09.11.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      eps    = 1
      MW_A   = 0.100
      v0     = 0.002
      C0_A   = 0.09
      Dax    = 1
      TWand  = 423.15
      alpha  = 100
      Temp10 = 423.15
      lam    = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      k, C00, C, y, z
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION dC_z
      dC_z = y

*     FUNCTION dy_z
      r    = -k*C
      dy_z = (v0/eps*y + r)/Dax
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C0
      C0 = C00
C
*     FUNCTION y0
      y0 = -(C00 - C0_A)/Dax
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cfit
      Cfit = C
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION G1
      G1 = y 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
