C
C------------------------------------------------------
C
C     Problem:     SS_REAC
C
C     Date:        26.11.1999
C
C------------------------------------------------------
C
*     REAL CONSTANT
      u = 0.01
      s1 = 1e-5
      s2 = 1e-4
      s3 = 1e-10
      s4 = 1e+2
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. system variables (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      k1, k2, k3, k4, HP, VA, VB, CX, CP, CI, p
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     nonlinear equations:
C
*     FUNCTION g1
      if (p.gt.0) then
        g1 = VA*HP/s1 - k1*sqrt(p)
      else
        g1 = 0
      endif
C
*     FUNCTION g2
      g2 = VB*HP/s2 - k2*VA
C
*     FUNCTION g3
      g3 = VB*HP*CI/s3 - k3*CX*(2 - CI)
C
*     FUNCTION g4
      g4 = CP/(CX*HP)/s4 - k4
C
*     FUNCTION g5
      g5 = HP + CI + CP - 2*VB - VA
C
*     FUNCTION g6
      g6 = (CX + CP + CI)/(1 - VA - VB + CI) - u
C
C------------------------------------------------------
C
C   - Initial values for solving systems of nonlinear
C     equations:
C
*     FUNCTION HP_0
      HP_0 = 0.001
C
*     FUNCTION VA_0
      VA_0 = 0.001
C
*     FUNCTION VB_0
      VB_0 = 0.1
C
*     FUNCTION CX_0
      CX_0 = 0.001
C
*     FUNCTION CP_0
      CP_0 = 0.001
C
*     FUNCTION CI_0
      CI_0 = 0.001
C
C------------------------------------------------------
C
C   - Fitting criterion:
C
*     FUNCTION fit
      fit = VA + VB - CI
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

