C
C------------------------------------------------------
C
C     Problem:    SSHEATEX
C
C     Date:       13.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      U     = 1.5     
      CP    = 4.18   
      TCIN  = 323  
      TCOUT = 343   
      THIN  = 353   
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      WH, WC, TH, TCF, TCR, L
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION THP
      THP = -(U/(2*WH*CP))*(TH-TCR)-(U/(2*WH*CP))*(TH-TCF)
C
*     FUNCTION TCFP
      TCFP = (U/(2*WC*CP))*(TH-TCF)
C
*     FUNCTION TCRP
      TCRP = -(U/(2*WC*CP))*(TH-TCR)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION TH_0
      TH_0 = THIN
C
*     FUNCTION TCF_0
      TCF_0 = TCIN
C
*     FUNCTION TCR_0
      TCR_0 = TCOUT
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION TH_fit
      TH_fit=TH
C
*     FUNCTION TCF_fit
      TCF_fit=TCF
C
*     FUNCTION TCR_fit
      TCR_fit=TCR
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G
C      G = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
