C
C------------------------------------------------------
C
C     Problem:    SPHERE
C
C     Date:       23.03.1997
C
C------------------------------------------------------
C
*     SET OF INDICES
      IND = 1..4
C
C------------------------------------------------------
C
*     REAL CONSTANT
      R0 = 1.0
      E = 30800.0
      RG = 1.987
      RHO = 1.71
      CP = 0.3
      DH = 1276.0
      K0 = 1.26E+11
      TA = 125.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      K, T0, T, T_R, T_RR, R, TIME
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_P
      A = K/(RHO*CP)
      B = DH*K0/(RHO*CP)
      IF (R.GT.0) THEN
        T_P = A*(T_RR + (2.0/R)*T_R) + 
     /               B*EXP(-E/(RG*(T+273.16)))
      ELSE
        T_P = 3.0*A*T_RR + B*EXP(-E/(RG*(T+273.16)))
      ENDIF
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION T_0
      T_0 = T0
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas:
C
*     FUNCTION T_RIGHT
      T_RIGHT = TA
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     borders of all areas, then at right borders of all 
C     areas for gradients:
C
*     FUNCTION T_R_LEFT
      T_R_LEFT = 0.0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT(I), I IN IND
      FIT(I) = T
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
