C
C------------------------------------------------------
C
C     Problem:    SPBEDRTD
C
C     Date:       08.02.01
C
C------------------------------------------------------
C 
*     REAL CONSTANT
      V1=0.4
      V2=0.3 
      V3=0.05       
      Vtot=1.8       
      CSTART=1
      V=(Vtot-V1-V2-V3)/6
      C3ADD=2
C
C------------------------------------------------------
C 
C   - Independent variables in the following order:
C     1. parameters to be estimated (x)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      F0, F, C1, C2, C3, C4, C5, C6, C7, C8, C9, T
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION C1P
      F1=F0+3*F
      F2=F1+3*F   
      F3=F2
      F4=F3-F
      F5=F4-F
      F6=F5-F
      F7=F6-F
      F8=F7-F
      C0=C9
      C1P=(F0*C0+F*(C7+C8+C9)-(F0+3*F)*C1)/V1
C
*     FUNCTION C2P
      C2P=(F1*C1+F*(C4+C5+C6)-(F1+3*F)*C2)/V3
C
*     FUNCTION C3P
      C3P=F2*(C2-C3)/V
C
*     FUNCTION C4P
      C4P=F3*(C3-C4)/V
C
*     FUNCTION C5P
      C5P=F4*(C4-C5)/V
C
*     FUNCTION C6P
      C6P=F5*(C5-C6)/V
C
*     FUNCTION C7P
      C7P=F6*(C6-C7)/V
C
*     FUNCTION C8P
      C8P=F7*(C7-C8)/V
C
*     FUNCTION C9P
      C9P=F8*(C8-C9)/V
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION C1_0
      IF (T.LT.0.1) THEN
        C1_0=CSTART
      ELSE
        C1_0=C1
      ENDIF
C
*     FUNCTION C2_0
      IF (T.LT.0.1) THEN
        C2_0=CSTART
      ELSE
        C2_0=C2
      ENDIF
C
*     FUNCTION C3_0
      IF (T.LT.0.1) THEN
        C3_0=0
      ELSE
        C3_0=C3+C3ADD
      ENDIF
C
*     FUNCTION C4_0
      IF (T.LT.0.1) THEN
        C4_0=0
      ELSE
        C4_0=C4
      ENDIF
C
*     FUNCTION C5_0
      IF (T.LT.0.1) THEN
        C5_0=0
      ELSE
        C5_0=C5
      ENDIF
C
*     FUNCTION C6_0
      IF (T.LT.0.1) THEN
        C6_0=0
      ELSE
        C6_0=C6
      ENDIF
C
*     FUNCTION C7_0
      IF (T.LT.0.1) THEN
        C7_0=CSTART
      ELSE
        C7_0=C7
      ENDIF
C
*     FUNCTION C8_0
      IF (T.LT.0.1) THEN
        C8_0=CSTART
      ELSE
        C8_0=C8
      ENDIF
C
*     FUNCTION C9_0
      IF (T.LT.0.1) THEN
        C9_0=CSTART
      ELSE
        C9_0=C9
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION C1_FIT
      C1_FIT=C1
C
*     FUNCTION C2_FIT
      C2_FIT=C2
C
*     FUNCTION C3_FIT
      C3_FIT=C3
C
*     FUNCTION C4_FIT
      C4_FIT=C4
C
*     FUNCTION C5_FIT
      C5_FIT=C5
C
*     FUNCTION C6_FIT
      C6_FIT=C6
C
*     FUNCTION C7_FIT
      C7_FIT=C7
C
*     FUNCTION C8_FIT
      C8_FIT=C8
C
*     FUNCTION C9_FIT
      C9_FIT=C9
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
