C
C------------------------------------------------------
C
C     Problem:    SOUND
C
C     Date:       1.12.2003
C
C------------------------------------------------------
C
*     REAL CONSTANT
      p0 = 1
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      D1, D2, p, p_x, p_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION p1_t
      p1_t = D1*p_xx     
C
*     FUNCTION p2_t       
      f = 0.1 
      p2_t = D2*p_xx - f*p
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION p1_0
      p1_0 = p0
C
*     FUNCTION p2_0  
      p2_0 = 0
C 
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations:
C
c*     FUNCTION dh
c      dh = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0: 
C
c*     FUNCTION h0
c      h0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an 
C     area, etc.:
C
*     FUNCTION p1_left
      p1_left = p0
C
*     FUNCTION p2_left
      p2_left = p
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION p1_x_right
      p1_x_right = p_x
C
*     FUNCTION p2_x_right
      p2_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION fit
      fit = p
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION G1
C      G1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



