C
C------------------------------------------------------
C
C     Problem:    SORP_IS2
C
C     Date:       21.11.1996
C
C------------------------------------------------------
C
*     REAL CONSTANT
      D = 1.46
      q = 5.48
      theta = 0.23
      f = 1
      rho = 0.65
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. spatial variable (x)
C     7. time variable (t)
C
*     VARIABLE
      a, k, c, c_x, c_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_t
      if (c.gt.0) then
        phi_c = a**2*k*1000/(a + k*c)**2
      else
        phi_c = 0
      endif
      c_t = (D*c_xx - q*c_x)/(theta + rho*phi_c)
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION c_0
      c_0 = 0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION cl_x
      cl_x = q*(c - f)/D
C
*     FUNCTION cr_x
      cr_x = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = c
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
c*     FUNCTION g1
c      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C


