C
C------------------------------------------------------
C
C     Problem:    SOOT
C
C     Date:       15.01.02
C
C------------------------------------------------------
C
*     REAL CONSTANT
      Ru = 8.3144
      pStar = 101325
      TempStar = 3915
      rhoS = 2100
      WV = 0.036
      cS = 2079 
      k0 = 0.0241
      G = 7.037
      lambdaMpf = 1
      ab = 3E+9
      Temp0 = 1550
      TempInf = 1550
      sigma = 2
      E = 100
      pi = 3.1415926535
      Tempk0 = 273
      Sk = 194
      Rs = 287
      pInf = 101325
      eta0 = 1.7116E-5
      Tempeta0 = 273
      Seta = 111
      c1 = 3.742E-16
      c2 = 0.01439
      nInf = 1
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..20
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      r0, tlaser, r, Temp, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION r_t
      dHV = 6.579E-7*Temp**(-0.5364)
      r_t = -pStar/rhoS*sqrt(WV/(2*Ru*Temp))*exp(dHV*(Temp-TempStar)
     /      /(Ru*Temp*TempStar))
C
*     FUNCTION Temp_t
      kInf = k0*(Temp/Tempk0)**(2/3)*(Tempk0+Sk)/(Temp+Sk)
      eta = eta0*(TempInf/Tempeta0)**(2/3)*(Tempeta0+Seta)/(Temp+Seta)
      lamMpf = 2*eta*sqrt(Rs*TempInf)/pInf
      IL = E/(sigma*sqrt(2*pi))*exp(-(t-tlaser)**2/(2*sigma**2))
      rad = 2*pi*c1*nInf**2*sum(ab/(l**5*(exp(c2/(l*Temp))-1)),l in ind)
      Temp_t = - 3*rad/(r*rhoS*cS)
     /         - 3*(Temp-TempInf)*kInf/((1+0.5*G*lamMpf/r)
     /                                   *r*r*rhoS*cS)
     /         + 3*ab*IL/(4*r*rhoS*cS)
     /         + 3*dHV/(WV*r*cS)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION r_0
      if (t.lt.1) then
        r_0 = r0
      else
        r_0 = r
      endif
C
*     FUNCTION Temp_0
      if (t.lt.1) then
        Temp_0 = Temp0
      else
        Temp_0 = Temp
      endif
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION r_fit
      r_fit = r
C
*     FUNCTION Temp_fit
      Temp_fit = Temp
C
*     FUNCTION Int
      Int = E/(sigma*sqrt(2*pi))*exp(-(t-tlaser)**2/(2*sigma**2))
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



