C
C------------------------------------------------------
C
C     Problem:    SOLITON
C
C     Date:       10.06.97
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (ux)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (uxx)
C     5. If flux function is available, then one variable
C        for each equation is to be declared that contains
C        the flux derivative (flux)_x to be used subsequently.
C        Note that the flux function is defined on the left
C        hand side,i.e. take care of the sign! (fluxx)
C     6. variables identifying solution of coupled
C        ordinary differential equations (v)
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a, b, phi, mu, phi_x, mu_x, phi_xx, mu_xx, x, t
C
C------------------------------------------------------
C
C   - Functions defining the flux on the left-hand side
C     of the system of partial differential equations,
C     if available at all (order: functions in first
C     area, functions in second area, etc.):
C
C*     FUNCTION FLUX
C      FLUX = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION phi_t
      phi_t = mu
C
*     FUNCTION mu_t
      mu_t = phi_xx - sin(phi)  
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION phi_0
      phi_0 = a
C
*     FUNCTION mu_0
      mu_0 = b
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left borders of all areas, then
C     at right borders of all areas:
C
*     FUNCTION phi_xl
      phi_xl = 0
C
*     FUNCTION mu_xl
      mu_xl = 0
C
*     FUNCTION phi_xr
      phi_xr = 0.0
C
*     FUNCTION mu_xr
      mu_xr = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION FIT
      FIT = phi
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C
