C
C------------------------------------------------------
C
C     Problem:    SOIL
C
C     Date:       09.11.1995
C
C------------------------------------------------------
C
*     REAL CONSTANT
      T0 = 0.0104167
      C0 = 5800
      Vm = 100
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations, first the differential ones,
C        then the algebraic variables (u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE equation, if at all.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      pm, pim, Dm
      Cim, Cm, Cim_x, Cm_x, Cim_xx, Cm_xx
      x, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Cim_t
      Cim_t = pim*(Cm - Cim)
C
*     FUNCTION Cm_t
      Cm_t = Dm*Cm_xx - Vm*Cm_x - pm*(Cm - Cim)    
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: functions in
C     first area, functions in second area, etc.):
C
*     FUNCTION Cim0
      Cim0 = 0.0
C
*     FUNCTION Cm0
      Cm0 = 0.0
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. space 
C     variable first at left borders of all areas, then 
C     at right borders of all areas:
C
*     FUNCTION Cm_x_left
      IF (t.LT.t0) THEN
        Cm_x_left = (Cm - C0)*Vm/Dm  
      ELSE
        Cm_x_left = Cm*Vm/Dm
      ENDIF
C
*     FUNCTION Cm_x_right
      Cm_x_right = -Cm*Vm/Dm
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION Cm_fit
      Cm_fit = Cm - Dm/Vm*Cm_x
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C




