C
C------------------------------------------------------
C
C     Problem:    SMALL_EX
C
C     Date:       27.01.2004
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      mu1, mu2, x1, x2, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION x1_t
      x1_t = 0.2*(2*mu1 + 3*mu2)*x1 + 1.2*(mu1 - mu2)*x2
C
*     FUNCTION x2_t
      x2_t = 0.2*(mu1 - mu2)*x1 + 0.2*(3*mu1 + 2*mu2)*x2
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION x1_0
      x1_0 = 1
C
*     FUNCTION x2_0
      x2_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION x1_fit
      x1_fit = x1
c  0.4*exp(mu1*t) + 0.6*exp(mu2*t) 
C
*     FUNCTION x2_fit
      x2_fit = x2
c  0.2*exp(mu1*t) - 0.2*exp(mu2*t) 
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C*     FUNCTION g1
C      g1 = ...
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

