C
C------------------------------------------------------
C
C     Problem:    SLUDGE
C
C     Date:       18.04.2002
C
C------------------------------------------------------
C
*     REAL CONSTANTS
      R = 8.314
      sk01 = 1E+5
      sk02 = 1E+18
      sk03 = 1E+21
      sk04 = 1E+22
      sk05 = 1E+17
      sk06 = 1E+12
      sE01 = 1E+4
      sE02 = 1E+5
      sE03 = 1E+5
      sE04 = 1E+5
      sE05 = 1E+5
      sE06 = 1E+5
      m01 = 34.5
      m02 = 4.70
      m03 = 4.66
      m04 = 1.31
      m05 = 3.93
      m06 = 3.12
C
C------------------------------------------------------
C
*     VARIABLE
      k01, k02, k03, k04, k05, k06 
      E01, E02, E03, E04, E05, E06
      m, x1, x2, x3, x4, x5, x6, t
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION m_t
      TEMP=303 + 0.25*t
      k1 = sk01*k01*exp(-sE01*E01/R/TEMP)
      k2 = sk02*k02*exp(-sE02*E02/R/TEMP)
      k3 = sk03*k03*exp(-sE03*E03/R/TEMP)
      k4 = sk04*k04*exp(-sE04*E04/R/TEMP)
      k5 = sk05*k05*exp(-sE05*E05/R/TEMP)
      k6 = sk06*k06*exp(-sE06*E06/R/TEMP)
      r1 = k1*(m01 - x1)
      r2 = k2*(m02 - x2)
      r3 = k3*(m03 - x3)
      r4 = k4*(m04 - x4)
      r5 = k5*(m05 - x5)
      r6 = k6*(m06 - x6)
      m_t = -r1 - r2 - r3 - r4 - r5 - r6
C
*     FUNCTION x1_t    
      x1_t = k1*(m01 - x1)
C
*     FUNCTION x2_t
      x2_t = k2*(m02 - x2)
C
*     FUNCTION x3_t
      x3_t = k3*(m03 - x3)
C
*     FUNCTION x4_t
      x4_t = k4*(m04 - x4)
C
*     FUNCTION x5_t
      x5_t = k5*(m05 - x5)
C
*     FUNCTION x6_t
      x6_t = k6*(m06 - x6)
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION m_0
      m_0 = 100
C
*     FUNCTION x1_0
      x1_0 = 0
C
*     FUNCTION x2_0
      x2_0 = 0
C
*     FUNCTION x3_0
      x3_0 = 0
C
*     FUNCTION x4_0
      x4_0 = 0
C
*     FUNCTION x5_0
      x5_0 = 0
C
*     FUNCTION x6_0
      x6_0 = 0
C
C------------------------------------------------------
C
C   - Fitting criteria:
C
*     FUNCTION m_fit
      m_fit = m
C
*     FUNCTION x1_fit
      x1_fit = x1
C
*     FUNCTION x2_fit
      x2_fit = x2
C
*     FUNCTION x3_fit
      x3_fit = x3
C
*     FUNCTION x4_fit
      x4_fit = x4
C
*     FUNCTION x5_fit
      x5_fit = x5
C
*     FUNCTION x6_fit
      x6_fit = x6
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

