C
C----------------------------------------------------------------
C
C     Problem:    SLIP
C  
C     Date:       08.05.1996
C
C----------------------------------------------------------------
C
*     PARAMETER
      ii = 17
      jj = 10
C
C----------------------------------------------------------------
C
*     SET OF INDICES
      harmi = 1..ii
      harmj = 1..jj
C
C----------------------------------------------------------------
C
*     REAL CONSTANTS
      PI=ACOS(-1)
      DREH=233
      PER=60/DREH
      P=2*PI/PER
      BOG=PI/180
      VAM=DREH/88
      WBMIT= 3.219515E-002
      GBMIT= 4.191512E-006
C
C----------------------------------------------------------------
C
*     TABLE WB(i), i IN harmi
       1     3.919838E-002
       2     5.179583E-003
       3     2.226558E-003
       4     3.557963E-004
       5     1.102032E-004
       6     1.980949E-005
       7     6.449622E-006
       8     1.338107E-006
       9     8.169716E-007
      10     4.876920E-007
      11     7.447937E-008
      12     1.895697E-007
      13     1.845634E-007
      14     2.658099E-007
      15     3.704487E-007
      16     1.884264E-007
      17     3.809286E-008
C
*     TABLE WP(i), i IN harmi
       1    -1.623779E+002
       2     5.209486E+001
       3     4.130599E+001
       4    -2.613233E+001
       5    -8.093697E+001
       6    -1.547569E+002
       7     1.373598E+002
       8     5.623559E+001
       9    -2.203839E+001
      10     1.108576E+002
      11    -1.771229E+002
      12    -5.370192E+001
      13     2.102015E+001
      14     1.514898E+000
      15     1.724337E+002
      16    -1.293816E+002
      17     8.914515E+001
C 
*     TABLE GB(i), i IN harmi
       1    3.608833E-001
       2    9.537686E-002
       3    6.150769E-002
       4    1.310140E-002
       5    5.065960E-003
       6    1.091684E-003
       7    3.928867E-004
       8    1.043311E-004
       9    4.145422E-005
      10    1.765435E-005
      11    5.521548E-006
      12    6.340877E-006
      13    6.728598E-006
      14    5.852177E-006
      15    1.109371E-005
      16    4.145777E-006
      17    2.256886E-006
C    
*     TABLE GP(i), i IN harmi
       1    -7.237407E+001
       2     1.420898E+002
       3     1.313082E+002
       4     6.368810E+001
       5     9.045156E+000
       6    -6.451551E+001
       7    -1.322295E+002
       8     1.451578E+002
       9     7.908413E+001
      10     4.214256E+000
      11     5.949893E+001
      12     3.729472E+001
      13     8.401183E+001
      14     8.856477E+001
      15     6.189272E+001
      16     2.503478E+001
      17     1.144205E+002
C
C----------------------------------------------------------------
C
*     MACRO Y2AUX
      WEG = SUM(WB(i)*COS(i*P*TT+WP(i)*BOG), i IN harmj)
      GES = VAM*GBMIT+SUM(VAM*GB(i)*COS(i*P*TT
     /          +GP(i)*BOG), i IN harmj)
      LAM1=(FREQ1/70)**2
      LAM2=(FREQ2/FREQ1)**2*LAM1
      AAA=-LAM1*LAM2/((LAM1-1)*(LAM2-1))
      BBB=-1/((LAM1-1)*(LAM2-1))
      CT=AAA*(140*PI)**2
      J=BBB
      OMEGA1=140*PI
      OMEGA2=ABS(SQRT((140*PI/BBB)**2))
      W2=-OMEGA1**2*(Y1+Y3) - 2*THETA*OMEGA1*(Y2+Y4)
     /    + 2*THETA*OMEGA1*GES 
      Y21=W2 + OMEGA1**2*WEG
      Y22=W2 + OMEGA1**2*(WEG+SPIEL)
      IF (TT.LT.T1) THEN
        Y2X=Y21
      ELSE
      IF (TT.LT.T2) THEN
        Y2X=0.0
      ELSE
      IF (TT.LT.T3) THEN
        Y2X=Y22
      ELSE
      IF (TT.LT.T3) THEN
        Y2X=0
      ELSE
      IF (TT.LT.T4) THEN
        Y2X=Y21
      ELSE
      IF (TT.LT.T5) THEN
        Y2X=0
      ELSE
      IF (TT.LT.T6) THEN
        Y2X=Y22
      ELSE
      IF (TT.LT.T7) THEN
        Y2X=0.0
      ELSE
        Y2X=Y21
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      Y2AUX=Y2X
C
*     MACRO Y4AUX
      WEG = SUM(WB(i)*COS(i*P*TT+WP(i)*BOG), i IN harmj)
      GES = VAM*GBMIT+SUM(VAM*GB(i)*COS(i*P*TT
     /          +GP(i)*BOG), i IN harmj)
      LAM1=(FREQ1/70)**2
      LAM2=(FREQ2/FREQ1)**2*LAM1
      AAA=-LAM1*LAM2/((LAM1-1)*(LAM2-1))
      BBB=-1/((LAM1-1)*(LAM2-1))
      CT=AAA*(140*PI)**2
      J=BBB
      OMEGA1=140*PI
      OMEGA2=ABS(SQRT((140*PI/BBB)**2))
      W4=-OMEGA2**2*(Y1+Y3) - 2*THETA*OMEGA2*(Y2+Y4) -
     /       2*THPHI*OMEGA2*Y4-CT/BBB*Y3 +
     /       2*THETA*OMEGA2*GES
      Y41=W4 + OMEGA2**2*WEG
      Y42=W4 + OMEGA2**2*(WEG+SPIEL)
      IF (TT.LT.T1) THEN
        Y4AUX=Y41
      ELSE
      IF (TT.LT.T2) THEN
        Y4AUX=0.0
      ELSE
      IF (TT.LT.T3) THEN
        Y4AUX=Y42
      ELSE
      IF (TT.LT.T3) THEN
        Y4AUX=0
      ELSE
      IF (TT.LT.T4) THEN
        Y4AUX=Y41
      ELSE
      IF (TT.LT.T5) THEN
        Y4AUX=0
      ELSE
      IF (TT.LT.T6) THEN
        Y4AUX=Y42
      ELSE
      IF (TT.LT.T7) THEN
        Y4AUX=0
      ELSE
        Y4AUX=Y41
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
      ENDIF
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of ordinary
C        differential equations (y)
C     3. concentration variable, if exists (c)
C     4. time variable (t)
C
*     VARIABLE
      THETA, THPHI, FREQ1, FREQ2, SPIEL
      T1, T2, T3, T4, T5, T6, T7
      Y1, Y2, Y3, Y4, TT
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     ordinary differential equations:
C
*     FUNCTION Y1P
      Y1P=Y2
C
*     FUNCTION Y2P
      Y2P=Y2AUX
C
*     FUNCTION Y3P
      Y3P=Y4
C
*     FUNCTION Y4P
      Y4P=Y4AUX
C
C------------------------------------------------------
C
C   - Initial values for solving systems of ordinary
C     differential equations (t=0):
C
*     FUNCTION Y10
      IF (TT.LT.0.001) THEN
        LAM1=(FREQ1/70)**2
        LAM2=(FREQ2/FREQ1)**2*LAM1
        Y10=1/LAM1*SUM(WB(i)*COS((i)*P*0.0
     /       +WP(i)*BOG), i IN harmj)
      ELSE
        Y10=Y1
      ENDIF
C
*     FUNCTION Y20
      IF (TT.LT.0.001) THEN
        Y20=1/LAM1*(VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*0.0
     /       +GP(i)*BOG), i IN harmj))
      ELSE
        Y20=Y2
      ENDIF
C
*     FUNCTION Y30
      IF (TT.LT.0.001) THEN
        Y30=(LAM1-1)/LAM1*(SUM(WB(i)*COS((i)*P*0.0
     /       +WP(i)*BOG), i IN harmj))
      ELSE
        Y30=Y3
      ENDIF
C
*     FUNCTION Y40
      IF (TT.LT.0.001) THEN
        Y40=(LAM1-1)/LAM1*(VAM*GBMIT+SUM(VAM*GB(i)*COS((i)*P*0.0
     /       +GP(i)*BOG), i IN harmj))
      ELSE
        Y40=Y4
      ENDIF
C
C------------------------------------------------------
C
C   - Fitting functions:
C
*     FUNCTION FIT
      FIT = Y2AUX + Y4AUX
C
*     FUNCTION Y1_FIT
      Y1_FIT = Y1
C
*     FUNCTION Y2_FIT
      Y2_FIT = Y2
C
*     FUNCTION Y3_FIT
      Y3_FIT = Y3
C
*     FUNCTION Y4_FIT
      Y4_FIT = Y4
C
C------------------------------------------------------
C
C   - Constraints:
C
*     FUNCTION G1
      G1 = T2 - T1
C
*     FUNCTION G2
      G2 = T3 - T2
C
*     FUNCTION G3
      G3 = T4 - T3
C
*     FUNCTION G4
      G4 = T5 - T4
C
*     FUNCTION G5
      G5 = T6 - T5
C
*     FUNCTION G6
      G6 = T7 - T6
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C



