C
C------------------------------------------------------
C
C     Problem:    SLAB_CTR
C
C     Date:       14.05.2002
C
C------------------------------------------------------
C
*     REAL CONSTANT
      K = 250
C
C------------------------------------------------------
C
*     SET OF INDICES
      ind = 1..10     
      indg = 1..8 
      indx = 1..20
C
C------------------------------------------------------
C
*     TABLE ex(j), j in indx
      1   0.00001
      2   1.0
      3   2.0 
      4   3.0
      5   4.0
      6   5.0
      7   6.0
      8   7.0
      9   8.0
      10  9.0
      11 10.0
      12 11.0
      13 12.0 
      14 13.0
      15 14.0
      16 15.0
      17 16.0
      18 17.0
      19 18.0
      20 19.0
C
C------------------------------------------------------
C
C   - Independent variables in the following order:
C     1. parameters to be estimated (p)
C     2. variables identifying solution of partial
C        differential equations(u)
C     3. variables identifying first spatial derivatives of
C        solution of partial differential equations (u_x)
C     4. variables identifying second spatial derivatives of
C        solution of partial differential equations (u_xx)
C     5. variables identifying solution of coupled
C        ordinary differential equations (v)
C     6. variables for flux functions, if available (one
C        variable for each function (f), then one for
C        each derivative (f_x). These names can be
C        inserted subsequently. Note that flux variables
C        must be declared for each PDE.
C     7. spatial variable (x)
C     8. time variable (t)
C
*     VARIABLE
      a(j), j in indx
      T, T_x, T_xx, x, time
C
C------------------------------------------------------
C
C   - Functions defining the flux depending on u and u_x,
C     if available (order: functions in first area, func-
C     tions in second area, etc.):
C
C*     FUNCTION flux
C      flux = ...
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     partial differential equations (order: all 
C     functions in first area, then all functions in
C     second area, etc.):
C
*     FUNCTION T_t
      T_t = T_xx
C
C------------------------------------------------------
C
C   - Initial values of system of partial differential
C     equations for t=0 (order: all initial values in 
C     first area, then all initial values in second 
C     area, etc.):
C
*     FUNCTION T_0
      T_0 = 0
C
C------------------------------------------------------
C
C   - Functions defining right-hand side of system of 
C     coupled ordinary differential equations, order 
C     defined by increasing spatial positions:
C
c*     FUNCTION v_t
c      v_t = ...
C
C------------------------------------------------------
C
C   - Initial values of system of coupled ordinary
C     differential equations for t=0 in the same order: 
C
c*     FUNCTION v_0
c      v_0 = ...
C
C------------------------------------------------------
C
C   - Boundary and transition functions first at left
C     border of an area, then at right border of an
C     area, etc.:
C
c*     FUNCTION T_left
c      T_left = ...
C
C------------------------------------------------------
C
C   - Boundary and transition gradients w.r.t. spatial 
C     variable first at left border of an area, then
C     at right border of an area, etc.:
C
*     FUNCTION T_x_left
      if (time.gt.0) then
        Tout = sum(a(j)*time**ex(j), j in indx)
      else
        Tout = 0.5
      endif
      T_x_left = K*(T - Tout)
C
*     FUNCTION T_x_right
      T_x_right = 0
C
C------------------------------------------------------
C
C   - Fitting criteria, order defined by increasing 
C     spatial positions:
C
*     FUNCTION fit(j), j in ind
      fit(j) = T
C  
*     FUNCTION Tout_ctrl
      if (time.gt.0) then
        Tout = sum(a(j)*time**ex(j), j in indx)
      else
        Tout = 0.5
      endif
      Tout_ctrl = Tout
C
C------------------------------------------------------
C
C   - Constraints (if exist):
C
*     FUNCTION g1(i), i in indg
      if (time.gt.0) then
        Tout = sum(a(j)*time**ex(j), j in indx)
      else
        Tout = 0.5
      endif
      g1(i) = Tout 
C
*     FUNCTION g2(i), i in indg
      if (time.gt.0) then
        Tout = sum(a(j)*time**ex(j), j in indx)
      else
        Tout = 0.5
      endif
      g2(i) = 0.6 - Tout 
C
C------------------------------------------------------
C
*     END
C
C------------------------------------------------------
C

